@echo off
rem ***********************************************************************************
rem **************BitSight VRM Nightly Launcher Batch File*****************************
rem **************Version: 1.0*********************************************************
rem ***********************************************************************************

rem SET Archer Instance name here
set ArcherInstanceName=Dev

rem NOTE: Script current working directory ("Start in" if using Windows Task Scheduler) needs to be where this batch file and node files exist.
rem Get the current directory
set BitSightVRMPath=%CD%

rem Get date time stamp for log file
set t=%date%_%time% 
set d=%t:~10,4%%t:~4,2%%t:~7,2%_%t:~15,2%%t:~18,2%
set d=%d: =0%
set curYYYYMM=%Date:~10,4%%Date:~4,2%

rem Create log file directory if it doesn't already exist
md "%BitSightVRMPath%\Logs" 2>nul
md "%BitSightVRMPath%\Logs\Nightly" 2>nul
md "%BitSightVRMPath%\Logs\Nightly\%curYYYYMM%" 2>nul
md "%BitSightVRMPath%\Logs\100" 2>nul
md "%BitSightVRMPath%\Logs\100\%curYYYYMM%" 2>nul
md "%BitSightVRMPath%\Logs\110" 2>nul
md "%BitSightVRMPath%\Logs\110\%curYYYYMM%" 2>nul
md "%BitSightVRMPath%\Logs\120" 2>nul
md "%BitSightVRMPath%\Logs\120\%curYYYYMM%" 2>nul
rem @ECHO Completed setting up log directories

rem Set the log file name
set logfile="%BitSightVRMPath%\Logs\Nightly\%curYYYYMM%\NightlyOverall_%d%.log"

rem Clean up existing error files if they exist
IF EXIST "%BitSightVRMPath%\Logs\error-100.txt" (
  DEL "%BitSightVRMPath%\Logs\error-100.txt"
)
IF EXIST "%BitSightVRMPath%\Logs\error-110.txt" (
  DEL "%BitSightVRMPath%\Logs\error-110.txt"
)
IF EXIST "%BitSightVRMPath%\Logs\error-120.txt" (
  DEL "%BitSightVRMPath%\Logs\error-120.txt"
)

rem Clean up existing success files if they exist
IF EXIST "%BitSightVRMPath%\Logs\success-100.txt" (
  DEL "%BitSightVRMPath%\Logs\success-100.txt"
)
IF EXIST "%BitSightVRMPath%\Logs\success-110.txt" (
  DEL "%BitSightVRMPath%\Logs\success-110.txt"
)
IF EXIST "%BitSightVRMPath%\Logs\success-120.txt" (
  DEL "%BitSightVRMPath%\Logs\success-120.txt"
)

rem Launch 100 script
set num=100
echo %BitSightVRMPath%\%num%-CreateProfile.js Starting... >> %logfile% 2>&1
node "%BitSightVRMPath%\%num%-CreateProfile.js" > "%BitSightVRMPath%\Logs\%num%\%curYYYYMM%\%num%-CreateProfile_%d%.log" 2>&1

set errFound=0
IF EXIST "%BitSightVRMPath%\Logs\error-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Error Log found"
)

IF NOT EXIST "%BitSightVRMPath%\Logs\success-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Success Log not found"
)

rem Launch 110 script
set num=110
echo %BitSightVRMPath%\%num%-UpdateArcherTPP.js Starting... >> %logfile% 2>&1
node "%BitSightVRMPath%\%num%-UpdateArcherTPP.js" > "%BitSightVRMPath%\Logs\%num%\%curYYYYMM%\%num%-UpdateArcherTPP_%d%.log" 2>&1

set errFound=0
IF EXIST "%BitSightVRMPath%\Logs\error-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Error Log found"
)

IF NOT EXIST "%BitSightVRMPath%\Logs\success-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Success Log not found"
)

rem Launch 120 script
set num=120
echo %BitSightVRMPath%\%num%-UpdateArcherVendorFindings.js Starting... >> %logfile% 2>&1
node "%BitSightVRMPath%\%num%-UpdateArcherVendorFindings.js" > "%BitSightVRMPath%\Logs\%num%\%curYYYYMM%\%num%-UpdateArcherVendorFindings_%d%.log" 2>&1

set errFound=0
IF EXIST "%BitSightVRMPath%\Logs\error-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Error Log found"
)

IF NOT EXIST "%BitSightVRMPath%\Logs\success-%num%.txt" (
	set errFound=1
	echo "Error with %num% - Success Log not found"
)

rem Check if error file exists
IF %errFound%==1 (
	echo Overall Error! >> %logfile% 2>&1
	rem Format this text to anything for monitoring/alerts
	echo ERROR: BitSight VRM Nightly Job - Execution Server: %COMPUTERNAME% - Archer Instance: %ArcherInstanceName% - Log file: %logfile%
) ELSE (
	echo Overall Success! >> %logfile% 2>&1
	echo SUCCESS
)
